public class RootFinder {
	// Java version, based on Numerical Recipes, p. 354
	public static final int JMAX= 1000;       // Maximum number of bisections
	public static final double ERR_VAL= -10E10;

	public static double rtbis(MathFunction func, double x1, double x2, double xacc) {
		double dx, xmid, rtb;
		double f= func.f(x1);
		double fmid= func.f(x2);
		if (f*fmid >= 0.0) {
			System.out.println("Root must be bracketed for bisection");
			return ERR_VAL;
		}
		// Orient search so f>0 lies at x + dx
		if (f < 0.0) {
			dx= x2 - x1;
			rtb= x1;
		}
		else {
			dx= x1 - x2;
			rtb= x2;
		}
		for (int j=0; j < JMAX; j++) {
			dx *= 0.5;				// Cut interval in half
			xmid= rtb + dx;			// Find new x
			fmid= func.f(xmid);
			if (fmid <= 0.0)		// If f still < 0, move
				rtb= xmid;			// left boundary to mid
			if (Math.abs(dx) < xacc || fmid == 0.0)
				return rtb;
		}
		System.out.println("Too many bisections");
		return ERR_VAL;
	}

	public static void main(String[] args) {
		double root= RootFinder.rtbis(new Quadratic(), -1.0, 8.0, 1E-15);
		System.out.println("Root: " + root);
		System.out.println("Sqrt: " + Math.sqrt(2.0));
	}
}